<?php

namespace App\Conditions\QueryFields;

/**
 * Date time Query Field Class.
 *
 * @package UIType
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */
class DatetimeField extends DateField
{
	/** {@inheritdoc} */
	public function getValue()
	{
		if ('l' === $this->operator || 'g' === $this->operator) {
			return $this->value;
		}
		$val = explode(' ', $this->value);
		return current($val);
	}

	/**
	 * Get array value.
	 *
	 * @return mixed
	 */
	public function getArrayValue()
	{
		return explode(',', $this->value);
	}

	/** {@inheritdoc} */
	public function operatorE(): array
	{
		$value = $this->getValue();

		return ['between', $this->getColumnName(), $value . ' 00:00:00', $value . ' 23:59:59'];
	}

	/** {@inheritdoc} */
	public function operatorN(): array
	{
		$value = $this->getValue();

		return ['not between', $this->getColumnName(), $value . ' 00:00:00', $value . ' 23:59:59'];
	}

	/** {@inheritdoc} */
	public function operatorBw()
	{
		$value = $this->getArrayValue();

		return ['between', $this->getColumnName(), $value[0], $value[1]];
	}

	/** {@inheritdoc} */
	public function operatorB()
	{
		return ['<', $this->getColumnName(), $this->getValue() . ' 00:00:00'];
	}

	/** {@inheritdoc} */
	public function operatorA(): array
	{
		return ['>', $this->getColumnName(), $this->getValue() . ' 23:59:59'];
	}

	/**
	 * Greater operator.
	 *
	 * @return array
	 */
	public function operatorGreaterthannow()
	{
		return ['>', $this->getColumnName(), date('Y-m-d H:i:s')];
	}

	/**
	 * Smaller operator.
	 *
	 * @return array
	 */
	public function operatorSmallerthannow()
	{
		return ['<', $this->getColumnName(), date('Y-m-d H:i:s')];
	}

	/**
	 * Get value.
	 *
	 * @return mixed
	 */
	public function getStdValue()
	{
		if ('custom' === $this->operator) {
			$date = $this->getArrayValue();
			return [$date[0], $date[1]];
		}
		$date = \DateTimeRange::getDateRangeByType($this->operator);
		return [$date[0] . ' 00:00:00', $date[1] . ' 23:59:59'];
	}
}
