<?php
/**
 * Database migrator interface file.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Klaudia Łozowska <k.lozowska@yetiforce.com>
 */

declare(strict_types=1);

namespace App\Db\Migrations;

/**
 * Database migrator interface class.
 */
interface MigratorInterface
{
	/**
	 * Executes migrations from the current version to the latest.
	 *
	 * @return void
	 */
	public function migrate(): void;

	/**
	 * Get number of migrations to execute.
	 *
	 * @return int
	 */
	public function pendingMigrationsCount(): int;
}
