<?php
/**
 * Class to find routing between two points.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

namespace App\Map;

use App\Exceptions\AppException;

/**
 * Base Connector to get routing.
 */
class Routing extends BaseConnector
{
	/**
	 * @inheritdoc
	 */
	protected static string $configTableName = 'a_#__map_routing_driver_config';

	/**
	 * @inheritdoc
	 * @throws AppException
	 */
	public static function getDriverClass(string $driver): string
	{
		$className = "\\App\\Map\\Routing\\{$driver}";
		if (!class_exists($className)) {
			throw new AppException('ERR_CLASS_NOT_FOUND|'.$driver);
		}

		return $className;
	}
}
