<?php
/**
 * Esri WorldTopoMap driver file to get tile layer.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Klaudia Łozowska <k.lozowska@yetiforce.com>
 *
 * @see      https://server.arcgisonline.com/arcgis/rest/services/World_Topo_Map/MapServer
 */

declare(strict_types=1);

namespace App\Map\TileLayer;

/**
 * Connector for service Esri WorldTopoMap to get tile layer.
 */
class EsriWorldTopoMap extends Base
{
	/**
	 * @inheritdoc
	 */
	protected string $label = 'LBL_TILE_LAYER_ESRI_WORLDTOPOMAP';

	/**
	 * @inheritdoc
	 */
	protected string $url = 'https://www.arcgis.com/home/item.html?id=7dc6cea0b1764a1f9af2e679f642f0f5';

	/**
	 * @inheritdoc
	 */
	protected string $urlTemplate = 'https://server.arcgisonline.com/ArcGIS/rest/services/World_Topo_Map/MapServer/tile/{z}/{y}/{x}';

	/**
	 * @inheritdoc
	 */
	protected array $formFields = [];
}
