<?php

return [
	'modulesHierarchy' => [
		'Accounts' => ['level' => 0],
		'Leads' => ['level' => 0],
		'Vendors' => ['level' => 0],
		'Partners' => ['level' => 0],
		'Competition' => ['level' => 0],
		'OSSEmployees' => ['level' => 0],
		'Project' => ['level' => 1],
		'ServiceContracts' => ['level' => 1],
		'Campaigns' => ['level' => 1],
		'FBookkeeping' => ['level' => 1],
		'SSalesProcesses' => ['level' => 1],
		'ProjectMilestone' => ['level' => 2, 'parentModule' => 'Project'],
		'HelpDesk' => ['level' => 2, 'parentModule' => 'ServiceContracts'],
		'SQuoteEnquiries' => ['level' => 2, 'parentModule' => 'Campaigns'],
		'FInvoice' => ['level' => 2, 'parentModule' => 'FBookkeeping'],
		'SRequirementsCards' => ['level' => 2, 'parentModule' => 'SSalesProcesses'],
		'SCalculations' => ['level' => 2, 'parentModule' => 'SSalesProcesses'],
		'SQuotes' => ['level' => 2, 'parentModule' => 'SSalesProcesses'],
		'SSingleOrders' => ['level' => 2, 'parentModule' => 'SSalesProcesses'],
		'SRecurringOrders' => ['level' => 2, 'parentModule' => 'SSalesProcesses'],
		'SVendorEnquiries' => ['level' => 2, 'parentModule' => 'SSalesProcesses'],
		'ProjectTask' => ['level' => 3, 'parentModule' => 'ProjectMilestone'],
		'Contacts' => ['level' => 4],
	],
	/*
	 * 'Base module' => [
	 * 		['From module' => ['dest field name' => ['source field name']]],
	 * ],
	 */
	'modulesMapRelatedFields' => [// Map links between modules
		'ServiceContracts' => [
			'parent_id' => ['ServiceContracts' => ['sc_related_to' => ['parent_id', 'Accounts']]],
		],
		'ProjectTask' => [
			'projectmilestoneid' => ['ProjectMilestone' => ['projectid' => ['projectid']]],
			'parentid' => ['ProjectTask' => ['projectid' => ['projectid'], 'projectmilestoneid' => ['projectmilestoneid']]],
		],
		'Project' => [
			'servicecontractsid' => ['ServiceContracts' => ['linktoaccountscontacts' => ['sc_related_to', 'Accounts']]],
			'ssalesprocessesid' => ['SSalesProcesses' => ['linktoaccountscontacts' => ['related_to', 'Accounts']]],
			'parentid' => [
				'Project' => ['linktoaccountscontacts' => ['linktoaccountscontacts'], 'servicecontractsid' => ['servicecontractsid']]
			],
		],
		'HelpDesk' => [
			'projectid' => ['Project' => ['parent_id' => ['linktoaccountscontacts']]],
			'contact_id' => ['Contacts' => ['parent_id' => ['parent_id']]],
			'pssold_id' => ['Assets' => ['product_id' => ['product', 'Products'], 'parent_id' => ['parent_id', 'Accounts']], 'OSSSoldServices' => ['product_id' => ['serviceid', 'Services']]],
			'servicecontractsid' => ['ServiceContracts' => ['parent_id' => ['sc_related_to', 'Accounts'], 'ticketpriorities' => ['contract_priority']]],
		],
		'OSSTimeControl' => [
			'process' => [
				'Project' => ['link' => ['linktoaccountscontacts']],
				'ServiceContracts' => ['link' => ['sc_related_to']],
				'SSalesProcesses' => ['link' => ['related_to']],
			],
			'subprocess' => [
				'HelpDesk' => [
					'name' => ['ticket_title'],
					'link' => ['parent_id'],
					'process' => ['servicecontractsid'],
					'linkextend' => ['contact_id']
				],
			],
			'subprocess_sl' => [
				'ProjectTask' => ['process' => ['projectid'], 'name' => ['projecttaskname']],
			]
		],
		'SRequirementsCards' => [
			'salesprocessid' => ['SSalesProcesses' => ['accountid' => ['related_to']]],
		],
		'SCalculations' => [
			'salesprocessid' => ['SSalesProcesses' => ['accountid' => ['related_to']]],
		],
		'SVendorEnquiries' => [
			'salesprocessid' => ['SSalesProcesses' => ['accountid' => ['related_to']]],
		],
		'SQuotes' => [
			'accountid' => ['Accounts' => [
				'company' => ['accountname'],
				'addresslevel8a' => ['addresslevel8a'],
				'addresslevel7a' => ['addresslevel7a'],
				'addresslevel6a' => ['addresslevel6a'],
				'addresslevel5a' => ['addresslevel5a'],
				'addresslevel4a' => ['addresslevel4a'],
				'addresslevel3a' => ['addresslevel3a'],
				'addresslevel2a' => ['addresslevel2a'],
				'addresslevel1a' => ['addresslevel1a'],
				'localnumbera' => ['localnumbera'],
				'localnumbera' => ['localnumbera'],
				'poboxa' => ['poboxa'],
			]],
			'salesprocessid' => ['SSalesProcesses' => ['accountid' => ['related_to']]],
		],
		'SSingleOrders' => [
			'salesprocessid' => ['SSalesProcesses' => ['accountid' => ['related_to']]],
			'squotesid' => ['SQuotes' => ['accountid' => ['accountid']]],
			'accountid' => [
				'Accounts' => [
					'company_name_a' => ['accountname'], 'company_name_b' => ['accountname'],
					'vat_id_a' => ['vat_id'], 'vat_id_b' => ['vat_id'],
					'addresslevel8a' => ['addresslevel8a'], 'addresslevel8b' => ['addresslevel8b'],
					'addresslevel7a' => ['addresslevel7a'], 'addresslevel7b' => ['addresslevel7b'],
					'addresslevel6a' => ['addresslevel6a'], 'addresslevel6b' => ['addresslevel6b'],
					'addresslevel5a' => ['addresslevel5a'], 'addresslevel5b' => ['addresslevel5b'],
					'addresslevel4a' => ['addresslevel4a'], 'addresslevel4b' => ['addresslevel4b'],
					'addresslevel3a' => ['addresslevel3a'], 'addresslevel3b' => ['addresslevel3b'],
					'addresslevel2a' => ['addresslevel2a'], 'addresslevel2b' => ['addresslevel2b'],
					'addresslevel1a' => ['addresslevel1a'], 'addresslevel1b' => ['addresslevel1b'],
					'buildingnumbera' => ['buildingnumbera'], 'buildingnumberb' => ['buildingnumberb'],
					'localnumbera' => ['localnumbera'], 'localnumberb' => ['localnumberb'],
					'poboxa' => ['poboxa'], 'poboxb' => ['poboxb'],
					'email_a' => ['email1'], 'email_b' => ['email1'],
					'phone_a' => ['phone'], 'phone_b' => ['phone'],
				],
			],
		],
		'SRecurringOrders' => [
			'accountid' => ['Accounts' => ['company' => ['accountname']]],
			'salesprocessid' => ['SSalesProcesses' => ['accountid' => ['related_to']]],
			'accountid' => [
				'Accounts' => [
					'addresslevel8a' => ['addresslevel8a'],
					'addresslevel7a' => ['addresslevel7a'],
					'addresslevel6a' => ['addresslevel6a'],
					'addresslevel5a' => ['addresslevel5a'],
					'addresslevel4a' => ['addresslevel4a'],
					'addresslevel3a' => ['addresslevel3a'],
					'addresslevel2a' => ['addresslevel2a'],
					'addresslevel1a' => ['addresslevel1a'],
				],
			],
		],
		'SQuoteEnquiries' => [
			'salesprocessid' => ['SSalesProcesses' => ['accountid' => ['related_to']]],
		],
		'SSalesProcesses' => [
			'projectid' => ['Project' => ['accountid' => ['linktoaccountscontacts']]],
		],
		'IGRNC' => [
			'igrnid' => ['IGRN' => ['vendorid' => ['vendorid'], 'storageid' => ['storageid']]],
		],
		'IGDNC' => [
			'igdnid' => ['IGDN' => ['storageid' => ['storageid'], 'accountid' => ['accountid']]],
		],
		'Assets' => [
			'contactid' => ['Contacts' => ['parent_id' => ['parent_id']]],
		],
		'FInvoice' => [
			'accountid' => [
				'Accounts' => [
					'company_name_a' => ['accountname'], 'company_name_b' => ['accountname'],
					'vat_id_a' => ['vat_id'], 'vat_id_b' => ['vat_id'],
					'addresslevel8a' => ['addresslevel8a'], 'addresslevel8b' => ['addresslevel8b'],
					'addresslevel7a' => ['addresslevel7a'], 'addresslevel7b' => ['addresslevel7b'],
					'addresslevel6a' => ['addresslevel6a'], 'addresslevel6b' => ['addresslevel6b'],
					'addresslevel5a' => ['addresslevel5a'], 'addresslevel5b' => ['addresslevel5b'],
					'addresslevel4a' => ['addresslevel4a'], 'addresslevel4b' => ['addresslevel4b'],
					'addresslevel3a' => ['addresslevel3a'], 'addresslevel3b' => ['addresslevel3b'],
					'addresslevel2a' => ['addresslevel2a'], 'addresslevel2b' => ['addresslevel2b'],
					'addresslevel1a' => ['addresslevel1a'], 'addresslevel1b' => ['addresslevel1b'],
					'buildingnumbera' => ['buildingnumbera'], 'buildingnumberb' => ['buildingnumberb'],
					'localnumbera' => ['localnumbera'], 'localnumberb' => ['localnumberb'],
					'poboxa' => ['poboxa'], 'poboxb' => ['poboxb'],
					'email_a' => ['email1'], 'email_b' => ['email1'],
					'phone_a' => ['phone'], 'phone_b' => ['phone'],
				],
			],
		],
		'FCorectingInvoice' => [
			'finvoiceid' => [
				'FInvoice' => [
					'subject' => ['subject'], 'accountid' => ['accountid'],
					'paymentdate' => ['paymentdate'], 'saledate' => ['saledate'],
					'issue_time' => ['issue_time'], 'payment_methods' => ['payment_methods'],
					'addresslevel8a' => ['addresslevel8a'], 'addresslevel7a' => ['addresslevel7a'],
					'addresslevel6a' => ['addresslevel6a'], 'addresslevel5a' => ['addresslevel5a'],
					'addresslevel4a' => ['addresslevel4a'], 'addresslevel3a' => ['addresslevel3a'],
					'addresslevel2a' => ['addresslevel2a'], 'addresslevel1a' => ['addresslevel1a'],
					'company_name_a' => ['company_name_a'], 'first_name_a' => ['first_name_a'],
					'last_name_a' => ['last_name_a'], 'vat_id_a' => ['vat_id_a'],
				]
			],
		],
	],
	'modulesMap1M' => [// Base => Parent
		'OSSEmployees' => ['MultiCompany'],
		'Contacts' => ['Accounts'],
		'HelpDesk' => ['Accounts', 'Vendors'],
		'SSalesProcesses' => ['Accounts'],
		'SQuotes' => ['SSalesProcesses'],
		'FInvoice' => ['Accounts'],
		'SSingleOrders' => ['SSalesProcesses'],
		'SRecurringOrders' => ['SSalesProcesses', 'SQuotes'],
		'FBookkeeping' => ['Accounts'],
		'Project' => ['Accounts'],
		'ProjectTask' => ['Project'],
		'ProjectMilestone' => ['Project'],
		'ServiceContracts' => ['Accounts'],
		'Faq' => ['Products'],
		'PaymentsOut' => ['Accounts'],
		'PaymentsIn' => ['Accounts'],
		'OSSTimeControl' => ['Accounts', 'Project', 'HelpDesk', 'Leads'],
		'HolidaysEntitlement' => ['OSSEmployees'],
		'OSSSoldServices' => ['Accounts', 'Leads'],
		'OSSOutsourcedServices' => ['Accounts', 'Leads'],
		'Assets' => ['Accounts', 'Leads'],
		'OutsourcedProducts' => ['Accounts', 'Leads'],
		'Calendar' => ['Accounts', 'Contacts', 'OSSEmployees', 'Leads', 'Vendors', 'HelpDesk', 'Project', 'HelpDesk', 'ServiceContracts', 'Campaigns'],
	],
	'modulesMapMMBase' => ['Services', 'Reservations'],
	'modulesMapMMCustom' => [
		'Documents' => ['table' => 'vtiger_senotesrel', 'rel' => 'crmid', 'base' => 'notesid'],
		'Products' => ['table' => 'vtiger_seproductsrel', 'rel' => 'crmid', 'base' => 'productid'],
		'OSSMailView' => ['table' => 'vtiger_ossmailview_relation', 'rel' => 'crmid', 'base' => 'ossmailviewid'],
	],
];
