<?php

/**
 * Password Action Class.
 *
 * @package Settings.Action
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Adrian Kon <a.kon@yetiforce.com>
 */

use App\Exceptions\NoPermittedForAdmin;
use App\Map;
use App\Purifier;
/**
 * Controller for map password action.
 */
class Settings_Map_Password_Action extends Settings_Vtiger_Password_Action
{
	use \App\Controller\ExposeMethod;

	/** {@inheritdoc} */
	public function __construct()
	{
		parent::__construct();
		$this->exposeMethod('getPwd');
	}

	/** {@inheritdoc} */
	public function getPwd(App\Request $request)
	{
	 	$tab = $request->getByType('tab', Purifier::STANDARD);
		$connectorClass = match ($tab) {
			'TileLayer' =>Map\Layer::class,
			'Coordinates' => Map\Coordinates::class,
			'Routing' => Map\Routing::class,
			'default' => throw new NoPermittedForAdmin('ERR_ILLEGAL_VALUE'),
		};
		$driver = (new $connectorClass)::getInstance($request->getByType('driver', Purifier::STANDARD));
		\Settings_Vtiger_Tracker_Model::addBasic('show hidden data');
		$response = new Vtiger_Response();
		$response->setResult(['success' => true, 'text' => $driver->getConfig()['api_key'] ?? '']);
		$response->emit();
	}
}
