<?php
/**
 * UserAuth module model file.
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 * @author Antoni Kiszka <a.kiszka@yetiforce.com>
 */

/**
 * UserAuth module model class.
 */
class Settings_UserAuth_Module_Model extends Settings_Vtiger_Module_Model
{
	/**
	 * @var string
	 */
	public $baseTable = 'i_#__auth';

	/**
	 * @var string
	 */
	public $baseIndex = 'id';

	/**
	 * Secondary index to fetch the values.
	 *
	 * @var string
	 */
	public $secondaryIndex = 'providertype';

	/**
	 * @var string
	 */
	public $nameFields = ['name'];

	/**
	 * @var string[]
	 */
	public $listFields = ['name' => 'FL_NAME', 'providertype' => 'FL_PROVIDER', 'isactive' => 'FL_STATUS'];

	/**
	 * @var string
	 */
	public $name = 'UserAuth';

	/**
	 * Get the secondary index.
	 *
	 * @return string
	 */
	public function getSecondaryIndex(): string
	{
		return $this->secondaryIndex;
	}

	/**
	 * Function to get Create view url.
	 *
	 * @return string Url
	 */
	public function getCreateRecordUrl()
	{
		return 'index.php?module=' . $this->getName() . '&parent=' . $this->getParentName() . '&view=Create';
	}

	/**
	 * Function to get List view url.
	 *
	 * @return string Url
	 */
	public function getListViewUrl()
	{
		return 'index.php?module=' . $this->getName() . '&parent=' . $this->getParentName() . '&view=List';
	}
}
