<?php
/**
 * Create UserAuth provider view file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

/**
 * Create UserAuth provider view class.
 */
class Settings_UserAuth_Create_View extends \App\Controller\ModalSettings
{
	/** {@inheritdoc} */
	public $modalIcon = 'fas fa-plus';
	/** {@inheritdoc} */
	public $modalSize = 'modal-md';
	/** {@inheritdoc} */
	public $successBtn = 'LBL_NEXT';
	/** {@inheritdoc} */
	protected $pageTitle = 'LBL_USERAUTH_CREATE';

	/** {@inheritdoc} */
	public function process(App\Request $request)
	{
		$moduleName = $request->getModule(false);
		$viewer = $this->getViewer($request);
		$viewer->assign('MODULE_NAME', $request->getModule());
		$viewer->assign('PROVIDERS', \App\UserAuth::getProviders());
		$viewer->view('Create.tpl', $moduleName);
	}
}
