<?php

/**
 * Email PDF Template Task Class.
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 * @author Radoslaw Skrzypczak <r.skrzypczak@yetiforce.com>
 */
require_once 'modules/com_vtiger_workflow/tasks/VTEmailTemplateTask.php';
class VTSendPdf extends VTEmailTemplateTask
{
	/** @var bool Sending email takes more time, this should be handled via queue all the time. */
	public $executeImmediately = true;

	/**
	 * Get field names.
	 *
	 * @return string[]
	 */
	public function getFieldNames()
	{
		return [
			'pdfTemplate', 'mailTemplate', 'email', 'emailoptout', 'smtp',
			'copy_email', 'reply_to', 'attachments', 'filesFromFields'
		];
	}

	/**
	 * Execute task.
	 *
	 * @param Vtiger_Record_Model $recordModel
	 */
	public function doTask($recordModel)
	{
		if (
			!empty($this->mailTemplate)
			&& !empty($this->pdfTemplate)
			&& \App\Record::isExists($this->mailTemplate, 'EmailTemplates')
			&& \Vtiger_PDF_Model::getInstanceById($this->pdfTemplate)
		) {
			$mailerContent['template'] = $this->mailTemplate;
			if (empty($this->smtp)) {
				$mailerContent['smtp_id'] = \App\Mail::getDefaultSmtp();
			} elseif (-1 === (int) $this->smtp) {
				$templateMail = \App\Mail::getTemplate($this->mailTemplate);
				$mailerContent['smtp_id'] = $templateMail['smtp_id'];
			} else {
				$mailerContent['smtp_id'] = $this->smtp;
			}
			$emailParser = \App\EmailParser::getInstanceByModel($recordModel);
			$emailParser->emailoptout = $this->emailoptout ? true : false;
			if ($this->email) {
				$emails = \is_array($this->email) ? implode(',', $this->email) : $this->email;
				$mailerContent['to'] = $emailParser->setContent($emails)->parse()->getContent(true);
			}
			if (empty($mailerContent['to'])) {
				return false;
			}
			if ('Contacts' === $recordModel->getModuleName() && !$recordModel->isEmpty('notifilanguage')) {
				$mailerContent['language'] = $recordModel->get('notifilanguage');
			}
			$mailerContent['template'] = $this->mailTemplate;
			$mailerContent['recordModel'] = $recordModel;
			if (!empty($this->copy_email)) {
				$mailerContent['bcc'] = $this->copy_email;
			}
			if (!empty($this->reply_to)) {
				$emailsReply = \is_array($this->reply_to) ? implode(',', $this->reply_to) : $this->reply_to;
				$mailerContent['reply_to'] = $emailParser->setContent($emailsReply)->parse()->getContent(true);
			}
			unset($emailParser);
			$pdf = \App\Pdf\Pdf::getInstanceByTemplateId($this->pdfTemplate);
			$template = $pdf->getTemplate();
			$template->setVariable('recordId', $recordModel->getId());
			$pdf->loadTemplateData();
			$filePath = $template->getPath();
			$pdf->output($filePath, 'F');
			$fileName = ($pdf->getFileName() ?: time()) . '.pdf';

			$mailerContent['attachments'] = [$filePath => $fileName];
			if ($attachments = $this->getAttachments($recordModel)) {
				$mailerContent['attachments']['ids'] = $attachments;
			}
			if (!empty($this->filesFromFields) && ($files = $this->getFilesFromFields($recordModel))) {
				$mailerContent['attachments'] = array_merge($mailerContent['attachments'], $files);
			}
			\App\Mailer::sendFromTemplate($mailerContent);
		}
	}
}
