'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 *************************************************************************************/"use strict";jQuery.Class("Vtiger_AdvanceFilter_Js",{getInstance:function getInstance(container){var instance,module=app.getModuleName(),moduleClassName1=module+"_AdvanceFilterEx_Js",moduleClassName2=module+"_AdvanceFilter_Js",moduleClassName3="Vtiger_AdvanceFilterEx_Js";return instance="undefined"==typeof window[moduleClassName1]?"undefined"==typeof window[moduleClassName2]?"undefined"==typeof window[moduleClassName3]?new window["Vtiger_AdvanceFilter_Js"](container):new window[moduleClassName3](container):new window[moduleClassName2](container):new window[moduleClassName1](container),instance}},{filterContainer:!1,//Hold the conditions for a particular field type
fieldTypeConditionMapping:!1,//Hold the condition and their label translations
conditonOperatorLabelMapping:!1,dateConditionInfo:!1,fieldModelInstance:!1,//Holds fields type and conditions for which it needs validation
validationSupportedFieldConditionMap:{email:["e","n"]},//Hols field type for which there is validations always needed
allConditionValidationNeededFieldList:["double","integer","currency"],//used to eliminate mutiple times validation registrations
validationForControlsRegistered:!1,init:function init(container){"undefined"==typeof container&&(container=jQuery(".filterContainer")),container.is(".filterContainer")?this.setFilterContainer(container):this.setFilterContainer(jQuery(".filterContainer",container)),this.initialize();},getModuleName:function getModuleName(){return "AdvanceFilter"},/**
		 * Function  to initialize the advance filter
		 */initialize:function initialize(){this.registerEvents(),this.initializeOperationMappingDetails(),this.loadFieldSpecificUiForAll();},/**
		 * Function which will save the field condition mapping condition label mapping
		 */initializeOperationMappingDetails:function initializeOperationMappingDetails(){var filterContainer=this.getFilterContainer();return this.fieldTypeConditionMapping=jQuery("input[name=\"advanceFilterOpsByFieldType\"]",filterContainer).data("value"),this.conditonOperatorLabelMapping=jQuery("input[name=\"advanceFilterOptions\"]",filterContainer).data("value"),this.dateConditionInfo=jQuery("[name=\"date_filters\"]").data("value"),this},/**
		 * Function to get the container which holds all the filter elements
		 * @return jQuery object
		 */getFilterContainer:function getFilterContainer(){return this.filterContainer},/**
		 * Function to set the filter container
		 * @params : element - which represents the filter container
		 * @return : current instance
		 */setFilterContainer:function setFilterContainer(element){return this.filterContainer=element,this},getDateSpecificConditionInfo:function getDateSpecificConditionInfo(){return this.dateConditionInfo},/**
		 * Function which will return set of condition for the given field type
		 * @return array of conditions
		 */getConditionListFromType:function getConditionListFromType(fieldType){var fieldTypeConditions=this.fieldTypeConditionMapping[fieldType];return ("D"==fieldType||"DT"==fieldType)&&(fieldTypeConditions=fieldTypeConditions.concat(this.getDateConditions(fieldType))),fieldTypeConditions},getDateConditions:function getDateConditions(fieldType){if("D"!=fieldType&&"DT"!=fieldType)return [];var dateFilters=this.getDateSpecificConditionInfo();return Object.keys(dateFilters)},/**
		 * Function to get the condition label
		 * @param : key - condition key
		 * @reurn : label for the condition or key if it doest not contain in the condition label mapping
		 */getConditionLabel:function getConditionLabel(key){return key in this.conditonOperatorLabelMapping?this.conditonOperatorLabelMapping[key]:key in this.getDateSpecificConditionInfo()?this.getDateSpecificConditionInfo()[key].label:key},/**
		 * Function to check if the field selected is empty field
		 * @params : select element which represents the field
		 * @return : boolean true/false
		 */isEmptyFieldSelected:function isEmptyFieldSelected(fieldSelect){var selectedOption=fieldSelect.find("option:selected");//assumption that empty field will be having value none
return !("none"!=selectedOption.val())},/**
		 * Function to get the add condition elements
		 * @returns : jQuery object which represents the add conditions elements
		 */getAddConditionElement:function getAddConditionElement(){var filterContainer=this.getFilterContainer();return jQuery(".addCondition button",filterContainer)},/**
		 * Function to add new condition row
		 * @params : condtionGroupElement - group where condtion need to be added
		 * @return : current instance
		 */addNewCondition:function addNewCondition(conditionGroupElement){var basicElement=$(".basic",conditionGroupElement),newRowElement=basicElement.find(".js-conditions-row").clone(!0,!0),selectElement=newRowElement.find("select").addClass("select2"),conditionList=$(".conditionList",conditionGroupElement);return conditionList.append(newRowElement),App.Fields.Picklist.showSelect2ElementView(selectElement,{dropdownParent:conditionGroupElement}),this},/**
		 * Function/Handler  which will triggered when user clicks on add condition
		 */addConditionHandler:function addConditionHandler(e){var element=jQuery(e.currentTarget),conditionGroup=element.closest("div.conditionGroup");this.addNewCondition(conditionGroup);},getFieldSpecificType:function getFieldSpecificType(fieldSelected){var fieldInfo=fieldSelected.data("fieldinfo"),type=fieldInfo.type;return "reference"==type?"V":fieldSelected.data("fieldtype")},/**
		 * Function to load condition list for the selected field
		 * @params : fieldSelect - select element which will represents field list
		 * @return : select element which will represent the condition element
		 */loadConditions:function loadConditions(fieldSelect){var row=fieldSelect.closest("div.js-conditions-row"),conditionSelectElement=row.find("select[name=\"comparator\"]"),group=row.find("[name=\"column_condition\"]"),conditionSelected=conditionSelectElement.val(),fieldSelected=fieldSelect.find("option:selected"),fieldSpecificType=this.getFieldSpecificType(fieldSelected),conditionList=this.getConditionListFromType(fieldSpecificType),fieldInfo=fieldSelected.data("fieldinfo");"undefined"==typeof conditionList&&(conditionList={},conditionList.none="None");var options="";for(var key in conditionList)if((-1==jQuery.inArray(fieldInfo.type,["rangeTime","image"])||-1!=jQuery.inArray(conditionList[key],["y","ny"]))&&(-1==jQuery.inArray(fieldInfo.type,["userCreator","owner","picklist","modules","tree","inventoryLimit","languages","currencyList","fileLocationType"])||-1==jQuery.inArray(conditionList[key],["s","ew","c","k"]))&&("om"!==conditionList[key]||-1!=jQuery.inArray(fieldInfo.type,["owner","sharedOwner","userCreator"]))&&(-1==jQuery.inArray(conditionList[key],["wr","nwr"])||-1!=jQuery.inArray(fieldInfo.type,["owner"]))&&(-1==jQuery.inArray(conditionList[key],["s","ew"])||-1==jQuery.inArray(fieldInfo.type,["taxes","multipicklist","categoryMultipicklist","sharedOwner"]))&&(-1==jQuery.inArray(conditionList[key],["bw","m","h"])||-1==jQuery.inArray(fieldInfo.type,["time"]))&&("d"!==conditionList[key]||"and"===group.val())&&conditionList.hasOwnProperty(key))//IE Browser consider the prototype properties also, it should consider has own properties only.
{var conditionValue=conditionList[key],conditionLabel=this.getConditionLabel(conditionValue);options+="<option value=\""+conditionValue+"\"",conditionValue==conditionSelected&&(options+=" selected=\"selected\" "),options+=">"+conditionLabel+"</option>";}return conditionSelectElement.empty().html(options).trigger("change"),conditionSelectElement},/**
		 * Functiont to get the field specific ui for the selected field
		 * @prarms : fieldSelectElement - select element which will represents field list
		 * @return : jquery object which represents the ui for the field
		 */getFieldSpecificUi:function getFieldSpecificUi(fieldSelectElement){var html,fieldModel=this.fieldModelInstance;if("d"===fieldModel.get("comparatorElementVal"))return html="<div class=\"checkbox\"><label><input type=\"checkbox\" name=\""+fieldModel.getName()+"\" value=\"0\" ",(1===fieldModel.getValue()||"1"===fieldModel.getValue())&&(html+="checked"),html+=" >"+app.vtranslate("JS_IGNORE_EMPTY_VALUES")+"</label></div>",$(html);if("boolean"===fieldModel.getType().toLowerCase()||"C"===fieldSelectElement.find("option:selected").data("fieldtype")){var selectedValue=fieldSelectElement.closest(".js-conditions-row").find("[data-value=\"value\"]").val();return html="<select class=\"select2\" name=\""+fieldModel.getName()+"\">",html+="<option value=\"0\"","0"===selectedValue&&(html+=" selected=\"selected\" "),html+=">"+app.vtranslate("JS_IS_DISABLED")+"</option>",html+="<option value=\"1\"","1"===selectedValue&&(html+=" selected=\"selected\" "),html+=">"+app.vtranslate("JS_IS_ENABLED")+"</option>",html+="</select>",$(html)}return $(fieldModel.getUiTypeSpecificHtml())},/**
		 * Function which will load the field specific ui for a selected field
		 * @prarms : fieldSelect - select element which will represents field list
		 * @return : current instance
		 */loadFieldSpecificUi:function loadFieldSpecificUi(fieldSelect){var selectedOption=fieldSelect.find("option:selected"),row=fieldSelect.closest("div.js-conditions-row"),fieldUiHolder=row.find(".fieldUiHolder"),conditionSelectElement=row.find("select[name=\"comparator\"]"),fieldInfo=selectedOption.data("fieldinfo"),valueType=fieldUiHolder.find("[name=\"".concat(fieldInfo.name,"\"]")).data("valuetype"),fieldType="string";"undefined"==typeof fieldInfo?fieldInfo={}:fieldType=fieldInfo.type;var comparatorElementVal=fieldInfo.comparatorElementVal=conditionSelectElement.val();("date"==fieldType||"datetime"==fieldType)&&(fieldInfo.dateSpecificConditions=this.getDateSpecificConditionInfo());var moduleName=this.getModuleName(),fieldModel=Vtiger_Field_Js.getInstance(fieldInfo,moduleName);this.fieldModelInstance=fieldModel;var fieldSpecificUi=this.getFieldSpecificUi(fieldSelect),fieldName=fieldModel.getName();//remove validation since we dont need validations for all eleements
// Both filter and find is used since we dont know whether the element is enclosed in some conainer like currency
-1<$.inArray(fieldModel.getType(),["multipicklist","sharedOwner","multiReferenceValue","taxes","categoryMultipicklist"])?fieldName+="[]":-1<$.inArray(fieldModel.getType(),["userCreator","picklist","owner","languages","modules","inventoryLimit","currencyList","fileLocationType"])&&fieldSpecificUi.is("select")&&("e"==comparatorElementVal||"n"==comparatorElementVal)&&(fieldName+="[]"),fieldSpecificUi.filter("[name=\""+fieldName+"\"]").addClass("form-control"),fieldSpecificUi.filter("[name=\""+fieldName+"\"]").attr("data-value","value").removeAttr("data-validation-engine"),fieldSpecificUi.find("[name=\""+fieldName+"\"]").attr("data-value","value").removeAttr("data-validation-engine"),"currency"==fieldModel.getType()&&(fieldSpecificUi.filter("[name=\""+fieldName+"\"]").attr("data-decimal-separator",fieldInfo.decimal_separator).attr("data-group-separator",fieldInfo.group_separator),fieldSpecificUi.find("[name=\""+fieldName+"\"]").attr("data-decimal-separator",fieldInfo.decimal_separator).attr("data-group-separator",fieldInfo.group_separator)),valueType&&(this.fieldModelInstance.data.workflow_valuetype=valueType),fieldUiHolder.html(fieldSpecificUi),fieldSpecificUi.is("select")?App.Fields.Picklist.showSelect2ElementView(fieldSpecificUi,{dropdownParent:row}):0<fieldSpecificUi.has("input.dateField").length?App.Fields.Date.register(fieldSpecificUi):0<fieldSpecificUi.has("input.dateRangeField").length?App.Fields.Date.registerRange(fieldSpecificUi,{ranges:!1}):0<fieldSpecificUi.has("input.clockPicker").length&&app.registerEventForClockPicker(fieldSpecificUi),this.addValidationToFieldIfNeeded(fieldSelect);// Is Empty, today, tomorrow, yesterday conditions does not need any field input value - hide the UI
// re-enable if condition element is chosen.
return -1==["y","today","tomorrow","yesterday","smallerthannow","greaterthannow","ny","om","nom","wr","nwr"].indexOf(conditionSelectElement.val())?fieldUiHolder.show():fieldUiHolder.hide(),this},/**
		 * Function to load field specific ui for all the select elements - this is used on load
		 * to show field specific ui for all the fields
		 */loadFieldSpecificUiForAll:function loadFieldSpecificUiForAll(){var conditionsContainer=jQuery(".conditionList"),fieldSelectElement=jQuery("select[name=\"columnname\"]",conditionsContainer);return jQuery.each(fieldSelectElement,function(i,elem){var currentElement=jQuery(elem);"none"!=currentElement.val()&&currentElement.trigger("change",{_intialize:!0});}),this},/**
		 * Function to add the validation if required
		 * @prarms : selectFieldElement - select element which will represents field list
		 */addValidationToFieldIfNeeded:function addValidationToFieldIfNeeded(selectFieldElement){var selectedOption=selectFieldElement.find("option:selected"),row=selectFieldElement.closest("div.js-conditions-row"),fieldSpecificElement=row.find("[data-value=\"value\"]"),validator=selectedOption.attr("data-validator");return this.isFieldSupportsValidation(selectFieldElement)?(fieldSpecificElement.addClass("validate[funcCall[Vtiger_Base_Validator_Js.invokeValidation]]").attr("data-validation-engine","validate[funcCall[Vtiger_Base_Validator_Js.invokeValidation]]").attr("data-fieldinfo",JSON.stringify(selectedOption.data("fieldinfo"))),"undefined"!=typeof validator&&fieldSpecificElement.attr("data-validator",validator)):fieldSpecificElement.removeClass("validate[funcCall[Vtiger_Base_Validator_Js.invokeValidation]]").removeAttr("data-validation-engine"),this},/**
		 * Check if field supports validation
		 * @prarms : selectFieldElement - select element which will represents field list
		 * @return - boolen true/false
		 */isFieldSupportsValidation:function isFieldSupportsValidation(fieldSelect){var fieldModel=this.fieldModelInstance,type=fieldModel.getType();if(0<=jQuery.inArray(type,this.allConditionValidationNeededFieldList))return !0;var row=fieldSelect.closest("div.js-conditions-row"),conditionSelectElement=row.find("select[name=\"comparator\"]"),conditionValue=conditionSelectElement.val();return !!(type in this.validationSupportedFieldConditionMap&&0<=jQuery.inArray(conditionValue,this.validationSupportedFieldConditionMap[type]))},/**
		 * Function to retrieve the values of the filter
		 * @return : object
		 */getValues:function getValues(){var thisInstance=this,fieldList=["columnname","comparator","value","column_condition"],filterContainer=this.getFilterContainer(),conditionGroups=$(".conditionGroup",filterContainer),values={},columnIndex=0;return $(".conditionGroup",filterContainer).each(function(index,domElement){var groupElement=$(domElement);values[index+1]={},values[index+1].columns={},$(".conditionList .js-conditions-row",groupElement).each(function(i,conditionDomElement){var rowElement=$(conditionDomElement),fieldSelectElement=$("[name=\"columnname\"]",rowElement),valueSelectElement=$("[data-value=\"value\"]",rowElement);//To not send empty fields to server
if(thisInstance.isEmptyFieldSelected(fieldSelectElement))return !0;var key,field,fieldDataInfo=fieldSelectElement.find("option:selected").data("fieldinfo"),fieldType=fieldDataInfo.type,rowValues={};if("owner"===fieldType||"userCreator"===fieldType){for(key in fieldList)if(field=fieldList[key],"value"===field&&valueSelectElement.is("select")){var newValuesArr=valueSelectElement.val();rowValues[field]=newValuesArr?newValuesArr.join(","):"";}else rowValues[field]="value"===field&&valueSelectElement.is("input")?"checkbox"===valueSelectElement.attr("type")&&valueSelectElement.prop("checked")?1:valueSelectElement.val():$("[name=\""+field+"\"]",rowElement).val();}else if(-1<$.inArray(fieldType,["picklist","multipicklist","modules","sharedOwner","multiReferenceValue","inventoryLimit","languages","currencyList","taxes","fileLocationType","categoryMultipicklist"])){for(key in fieldList)if(field=fieldList[key],"value"===field&&"checkbox"===valueSelectElement.attr("type"))rowValues[field]=valueSelectElement.prop("checked")?1:valueSelectElement.val();else if("value"===field&&valueSelectElement.is("input")){var pickListValues=valueSelectElement.data("picklistvalues"),valuesArr=valueSelectElement.val().split(","),_newValuesArr=[];for(i=0;i<valuesArr.length;i++)"undefined"==typeof pickListValues[valuesArr[i]]?_newValuesArr.push(valuesArr[i]):_newValuesArr.push(pickListValues[valuesArr[i]]);rowValues[field]=_newValuesArr.join(",");}else if("value"===field&&valueSelectElement.is("select")&&-1<$.inArray(fieldType,["picklist","multipicklist","modules","sharedOwner","multiReferenceValue","inventoryLimit","languages","currencyList","taxes","fileLocationType","categoryMultipicklist"])){var value=valueSelectElement.val();rowValues[field]=null==value?value:value.join(",");}else rowValues[field]=$("[name=\""+field+"\"]",rowElement).val();}else for(key in fieldList)field=fieldList[key],rowValues[field]="value"===field?"checkbox"===valueSelectElement.attr("type")&&valueSelectElement.prop("checked")?1:valueSelectElement.val():$("[name=\""+field+"\"]",rowElement).val();rowElement.is(":last-child")&&(rowValues.column_condition=""),values[index+1].columns[columnIndex]=rowValues,columnIndex++;}),0<groupElement.find("div.groupCondition").length&&(values[index+1].condition=conditionGroups.find("div.groupCondition [name=\"condition\"]").val());}),values},/**
		 * Event handle which will be triggred on deletion of a condition row
		 */deleteConditionHandler:function deleteConditionHandler(e){var element=jQuery(e.currentTarget),row=element.closest(".js-conditions-row");row.remove();},/**
		 * Event handler which is invoked on add condition
		 */registerAddCondition:function registerAddCondition(){var thisInstance=this;this.getAddConditionElement().on("click",function(e){thisInstance.addConditionHandler(e);});},/**
		 * Function which will register field change event
		 */registerFieldChange:function registerFieldChange(){var filterContainer=this.getFilterContainer(),thisInstance=this;filterContainer.on("change","select[name=\"columnname\"]",function(e,data){var currentElement=jQuery(e.currentTarget);if("undefined"==typeof data||!0!=data._intialize){var row=currentElement.closest("div.js-conditions-row"),conditionSelectElement=row.find("select[name=\"comparator\"]");conditionSelectElement.empty();}thisInstance.loadConditions(currentElement),thisInstance.loadFieldSpecificUi(currentElement);});},/**
		 * Function which will register condition change
		 */registerConditionChange:function registerConditionChange(){var filterContainer=this.getFilterContainer(),thisInstance=this;filterContainer.on("change","select[name=\"comparator\"]",function(e){var comparatorSelectElement=jQuery(e.currentTarget),row=comparatorSelectElement.closest("div.js-conditions-row"),fieldSelectElement=row.find("select[name=\"columnname\"]");//To handle the validation depending on condtion
thisInstance.loadFieldSpecificUi(fieldSelectElement),thisInstance.addValidationToFieldIfNeeded(fieldSelectElement);});},/**
		 * Function to regisgter delete condition event
		 */registerDeleteCondition:function registerDeleteCondition(){var thisInstance=this,filterContainer=this.getFilterContainer();filterContainer.on("click",".js-condition-delete",function(e){thisInstance.deleteConditionHandler(e);});},/**
		 * Function which will regiter all events for this page
		 */registerEvents:function registerEvents(){this.registerAddCondition(),this.registerFieldChange(),this.registerDeleteCondition(),this.registerConditionChange();}}),Vtiger_Field_Js("AdvanceFilter_Field_Js",{},{getUiTypeSpecificHtml:function getUiTypeSpecificHtml(){var uiTypeModel=this.getUiTypeModel();return uiTypeModel.getUi()},getModuleName:function getModuleName(){var currentModule=app.getModuleName(),type=this.getType();return -1<$.inArray(type,["picklist","userCreator","multipicklist","owner","userCreator","modules","date","datetime","sharedOwner","multiReferenceValue","inventoryLimit","languages","currencyList","taxes","fileLocationType","categoryMultipicklist"])&&(currentModule="AdvanceFilter"),currentModule}}),Vtiger_Picklist_Field_Js("AdvanceFilter_Picklist_Field_Js",{},{getUi:function getUi(){var html="<select class=\"select2\" multiple name=\""+this.getName()+"[]\">",pickListValues=this.getPickListValues(),selectedOption=app.htmlDecode(this.getValue()),selectedOptionsArray=selectedOption.split(",");for(var option in pickListValues)html+="<option value=\""+option+"\" ",-1!=jQuery.inArray(option,selectedOptionsArray)&&(html+=" selected "),html+=">"+pickListValues[option]+"</option>";html+="</select>";var selectContainer=jQuery(html);return this.addValidationToElement(selectContainer),selectContainer}}),AdvanceFilter_Picklist_Field_Js("AdvanceFilter_Modules_Field_Js",{},{}),AdvanceFilter_Picklist_Field_Js("AdvanceFilter_Inventorylimit_Field_Js",{},{}),AdvanceFilter_Picklist_Field_Js("AdvanceFilter_Filelocationtype_Field_Js",{},{}),Vtiger_Multipicklist_Field_Js("AdvanceFilter_Multipicklist_Field_Js",{},{}),AdvanceFilter_Picklist_Field_Js("AdvanceFilter_Languages_Field_Js",{},{}),AdvanceFilter_Picklist_Field_Js("AdvanceFilter_Currencylist_Field_Js",{},{}),AdvanceFilter_Multipicklist_Field_Js("AdvanceFilter_Taxes_Field_Js",{},{}),Vtiger_Owner_Field_Js("AdvanceFilter_Owner_Field_Js",{},{getUi:function getUi(){var selectContainer,comparatorSelectedOptionVal=this.get("comparatorElementVal"),html="";if("e"===comparatorSelectedOptionVal||"n"===comparatorSelectedOptionVal||"shownerid"===this.getName()&&-1!=$.inArray(comparatorSelectedOptionVal,["c","k"])){html="<select class=\"select2\" multiple name=\""+this.getName()+"[]\">";var optGroup,pickListValues=this.getPickListValues(),selectedOption=app.htmlDecode(this.getValue());for(optGroup in pickListValues){html+="<optgroup label=\""+optGroup+"\">";var optionGroupValues=pickListValues[optGroup],option=void 0;for(option in optionGroupValues)html+="<option value=\""+option+"\" ",-1!=$.inArray(option,selectedOption.split(","))&&(html+=" selected "),html+=">"+optionGroupValues[option]+"</option>";html+="</optgroup>";}return html+="</select>",selectContainer=$(html),this.addValidationToElement(selectContainer),selectContainer}var tagsArray=[];return $.each(this.getPickListValues(),function(groups,blocks){$.each(blocks,function(i,e){tagsArray.push($.trim(e));});}),html="<input data-tags=\"\" type=\"hidden\" class=\"row select2\" name=\""+this.getName()+"\">",selectContainer=$(html).val(this.getValue()),selectContainer.data("tags",tagsArray),this.addValidationToElement(selectContainer),selectContainer}}),Vtiger_Multireferencevalue_Field_Js("AdvanceFilter_Multireferencevalue_Field_Js",{},{}),AdvanceFilter_Owner_Field_Js("AdvanceFilter_Sharedowner_Field_Js",{},{}),AdvanceFilter_Owner_Field_Js("AdvanceFilter_Usercreator_Field_Js",{},{}),Vtiger_Date_Field_Js("AdvanceFilter_Date_Field_Js",{},{/**
		 * Function to get the ui
		 * @return - input text field
		 */getUi:function getUi(){var comparatorSelectedOptionVal=this.get("comparatorElementVal"),dateSpecificConditions=this.get("dateSpecificConditions"),html="";if("bw"===comparatorSelectedOptionVal||"custom"===comparatorSelectedOptionVal){html="<div class=\"date\"><input class=\"dateRangeField form-control\" data-calendar-type=\"range\" name=\""+this.getName()+"\" data-date-format=\""+this.getDateFormat()+"\" type=\"text\" ReadOnly=\"true\" value=\""+this.getValue()+"\"></div>";var element=$(html),dateFieldUi=element.find(".dateRangeField");if(-1!==dateFieldUi.val().indexOf(",")){var valueArray=this.getValue().split(","),startDateTime=valueArray[0],endDateTime=valueArray[1];if(-1!==startDateTime.indexOf(" ")){var dateTime=startDateTime.split(" ");startDateTime=dateTime[0];}if(-1!==endDateTime.indexOf(" ")){var dateTimeValue=endDateTime.split(" ");endDateTime=dateTimeValue[0];}dateFieldUi.val(startDateTime+","+endDateTime);}else {// while changing to between/custom from equal/notequal/... we'll only have one value
var value=this.getValue().split(" "),startDate=value[0],endDate=value[0];""!==startDate&&""!==endDate&&dateFieldUi.val(startDate+","+endDate);}return this.addValidationToElement(element)}if(comparatorSelectedOptionVal in dateSpecificConditions){var startValue=dateSpecificConditions[comparatorSelectedOptionVal].startdate,endValue=dateSpecificConditions[comparatorSelectedOptionVal].enddate;return html="today"===comparatorSelectedOptionVal||"tomorrow"===comparatorSelectedOptionVal||"yesterday"===comparatorSelectedOptionVal?"<input name=\""+this.getName()+"\" type=\"text\" ReadOnly=\"true\" value=\""+startValue+"\">":"<input name=\""+this.getName()+"\" type=\"text\" ReadOnly=\"true\" value=\""+startValue+","+endValue+"\">",$(html)}var fieldUi=this._super(),dateTimeFieldValue=fieldUi.find(".dateField").val(),dateValue=dateTimeFieldValue.split(" ");if("00:00:00"===dateValue[1])dateTimeFieldValue=dateValue[0];else if("e"===comparatorSelectedOptionVal||"n"===comparatorSelectedOptionVal||"b"===comparatorSelectedOptionVal||"a"===comparatorSelectedOptionVal){var dateTimeArray=dateTimeFieldValue.split(" ");dateTimeFieldValue=dateTimeArray[0];}return fieldUi.find(".dateField").val(dateTimeFieldValue),fieldUi}}),AdvanceFilter_Date_Field_Js("AdvanceFilter_Datetime_Field_Js",{},{});
//# sourceMappingURL=AdvanceFilter.min.js.map
